/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import noppes.npcs.CustomNpcs;
import noppes.npcs.Server;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumSync;
import noppes.npcs.util.ValueUtil;

public class DialogGuiSettings {
    public boolean showNPC = true;
    public boolean npcInLeft = true;
    private int type = 0;
    private int showVerticalLines = 2;
    private int showHorizontalLines = 2;
    private double width = 0.85;
    private double optionH = 0.3333333333333333;
    private final float[] npcPos = new float[]{0.0f, 0.05f};
    private float npcScale = 2.0f;
    private float blurringLine = 0.05f;
    public int backBorderColor = Integer.MIN_VALUE;
    public int backWindowColor = -872415232;
    public int linesColor = 0x40FFFFFF;
    public int scrollLineColor = -12566464;
    public int hoverLineColor = -8327040;
    public int pointerColor = -1;
    public int sliderColor = -1862270977;
    public int selectOptionLeftColor = -266330080;
    public int selectOptionRightColor = -265277392;
    public int npcWidth;
    public int dialogWidth;
    public int guiLeft = 112;
    public int guiRight = 112;
    public int optionHeight;
    public int npcPosX;
    public int npcPosY;
    public ResourceLocation backTexture;
    public ResourceLocation windowTexture;

    public void load(NBTTagCompound compound) {
        this.showNPC = compound.func_74767_n("ShowNPC");
        this.npcInLeft = compound.func_74767_n("NPCInLeft");
        this.setType(compound.func_74762_e("WindowType"));
        this.setShowVerticalLines(compound.func_74762_e("ShowVerticalLines"));
        this.setShowHorizontalLines(compound.func_74762_e("ShowHorizontalLines"));
        this.backBorderColor = compound.func_74762_e("BackBorderColor");
        this.backWindowColor = compound.func_74762_e("BackWindowColor");
        this.linesColor = compound.func_74762_e("LinesColor");
        this.scrollLineColor = compound.func_74762_e("ScrollLineColor");
        this.hoverLineColor = compound.func_74762_e("HoverLineColor");
        this.pointerColor = compound.func_74762_e("PointerColor");
        this.sliderColor = compound.func_74762_e("SliderColor");
        this.selectOptionLeftColor = compound.func_74762_e("SelectOptionLeftColor");
        this.selectOptionRightColor = compound.func_74762_e("SelectOptionRightColor");
        this.setNpcPos(compound.func_74760_g("NPCPosX"), compound.func_74760_g("NPCPosY"));
        this.setNpcScale(compound.func_74760_g("NPCScale"));
        this.setBlurringLine(compound.func_74760_g("BlurringLine"));
        this.setWidth(compound.func_74769_h("WindowWidth"));
        this.setOptionHeight(compound.func_74769_h("OptionHeight"));
        this.backTexture = null;
        this.windowTexture = null;
        if (compound.func_150297_b("BackTexture", 8)) {
            this.backTexture = new ResourceLocation(compound.func_74779_i("BackTexture"));
        }
        if (compound.func_150297_b("WindowTexture", 8)) {
            this.windowTexture = new ResourceLocation(compound.func_74779_i("WindowTexture"));
        }
    }

    public NBTTagCompound save() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74757_a("ShowNPC", this.showNPC);
        compound.func_74757_a("NPCInLeft", this.npcInLeft);
        compound.func_74768_a("WindowType", this.type);
        compound.func_74768_a("ShowVerticalLines", this.showVerticalLines);
        compound.func_74768_a("ShowHorizontalLines", this.showHorizontalLines);
        compound.func_74768_a("BackBorderColor", this.backBorderColor);
        compound.func_74768_a("BackWindowColor", this.backWindowColor);
        compound.func_74768_a("LinesColor", this.linesColor);
        compound.func_74768_a("ScrollLineColor", this.scrollLineColor);
        compound.func_74768_a("HoverLineColor", this.hoverLineColor);
        compound.func_74768_a("PointerColor", this.pointerColor);
        compound.func_74768_a("SliderColor", this.sliderColor);
        compound.func_74768_a("SelectOptionLeftColor", this.selectOptionLeftColor);
        compound.func_74768_a("SelectOptionRightColor", this.selectOptionRightColor);
        compound.func_74776_a("NPCPosX", this.npcPos[0]);
        compound.func_74776_a("NPCPosY", this.npcPos[1]);
        compound.func_74776_a("NPCScale", this.npcScale);
        compound.func_74776_a("BlurringLine", this.blurringLine);
        compound.func_74780_a("WindowWidth", this.width);
        compound.func_74780_a("OptionHeight", this.optionH);
        if (this.backTexture != null) {
            compound.func_74778_a("BackTexture", this.backTexture.toString());
        }
        if (this.windowTexture != null) {
            compound.func_74778_a("WindowTexture", this.windowTexture.toString());
        }
        return compound;
    }

    public void init(double widthIn, double heightIn) {
        this.dialogWidth = (int)(widthIn * this.width);
        this.npcWidth = (int)widthIn - this.dialogWidth;
        this.optionHeight = (int)(heightIn * this.optionH);
        this.npcPosY = (int)(heightIn - heightIn * (double)this.npcPos[1]);
        switch (this.type) {
            case 0: {
                this.guiLeft = this.npcWidth;
                this.npcPosX = (int)((float)this.npcWidth * this.npcPos[0]) - this.npcWidth / 2;
                break;
            }
            case 1: {
                this.npcWidth /= 2;
                this.guiLeft = this.npcWidth;
                if (this.npcInLeft) {
                    this.npcPosX = (int)((float)this.npcWidth * this.npcPos[0]) - this.npcWidth / 2;
                    break;
                }
                this.npcPosX = this.dialogWidth + this.npcWidth / 2 + (int)((float)this.npcWidth * this.npcPos[0]);
                break;
            }
            case 2: {
                this.guiLeft = 0;
                this.npcPosX = this.dialogWidth + this.npcWidth / 2 + (int)((float)this.npcWidth * this.npcPos[0]);
            }
        }
        this.guiRight = this.dialogWidth + this.guiLeft;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int typeIn) {
        if (typeIn < 0) {
            typeIn *= -1;
        }
        this.type = typeIn % 3;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double widthIn) {
        if (widthIn < 0.0) {
            widthIn *= -1.0;
        }
        this.width = Math.min(Math.max(widthIn, 0.4), 0.9);
    }

    public double getOptionHeight() {
        return this.optionH;
    }

    public void setOptionHeight(double lengthIn) {
        if (lengthIn < 0.0) {
            lengthIn *= -1.0;
        }
        this.optionH = Math.min(Math.max(lengthIn, 0.15), 0.75);
    }

    public float[] getNpcPos() {
        return this.npcPos;
    }

    public void setNpcPos(float x, float y) {
        this.npcPos[0] = ValueUtil.correctFloat(x, -0.5f, 0.5f);
        this.npcPos[1] = ValueUtil.correctFloat(y, -0.25f, 0.25f);
    }

    public float getNpcScale() {
        return this.npcScale;
    }

    public void setNpcScale(float scale) {
        this.npcScale = ValueUtil.correctFloat(scale, 0.15f, 5.0f);
    }

    public int getShowHorizontalLines() {
        return this.showHorizontalLines;
    }

    public void setShowHorizontalLines(int typeIn) {
        if (typeIn < 0) {
            typeIn *= -1;
        }
        this.showHorizontalLines = typeIn % 3;
    }

    public int getShowVerticalLines() {
        return this.showVerticalLines;
    }

    public void setShowVerticalLines(int typeIn) {
        if (typeIn < 0) {
            typeIn *= -1;
        }
        this.showVerticalLines = typeIn % 3;
    }

    public float getBlurringLine() {
        return this.blurringLine;
    }

    public void setBlurringLine(float border) {
        this.blurringLine = ValueUtil.correctFloat(border, 0.0f, 0.25f);
    }

    public void update() {
        if (CustomNpcs.Server != null) {
            Server.sendToAll(CustomNpcs.Server, EnumPacketClient.SYNC_UPDATE, new Object[]{EnumSync.DialogGuiSettings, this.save()});
        }
    }

    public ResourceLocation getBackgroundTexture() {
        return this.backTexture;
    }

    public ResourceLocation getWindowTexture() {
        return this.windowTexture;
    }
}

